﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace 電子文書回覧追跡ツール {
    public partial class Form1 : Form {
        public Form1 This;
        public Form1() {
            InitializeComponent();
            This = this;
            //Microsoft.Win32.SystemEvents.SessionEnding += new Microsoft.Win32.SessionEndingEventHandler(SessionEnding);
        }
        //フィールド定義
        const int c_white = 1;
        const int c_color = 2;
        int icon = 0;
        public List<FileSystemWatcher> watcher = new List<FileSystemWatcher>();
        public List<string> folders = new List<string>();
        public List<string> types = new List<string>();
        public List<string> reaches = new List<string>();
        Folder folderForm;

        //追跡再開・停止ボタン押下
        private void button1_Click(object sender, EventArgs e) {
            switch(button1.Text) {
                case "追跡停止":
                    button1.Enabled = false;
                    btn消去.Enabled = false;
                    dataGridView2.Enabled = false;
                    foreach(FileSystemWatcher w in watcher) {
                        w.EnableRaisingEvents = false;
                    }
                    watcher.Clear();
                    this.normalFont(String.Format("　　追跡停止 {0}", DateTime.Now.ToString("MM/dd HH:mm:ss")));
                    lbl稼働状況.Text = "文書追跡停止中";
                    lbl稼働状況.ForeColor = System.Drawing.Color.Red;
                    notifyIcon1.Visible = notifyIcon2.Visible = false;
                    button1.Text = "追跡再開";
                    button1.Enabled = true;
                    closeCommunication(); //受信停止
                    //udp.Close();
                    return;
                case "追跡再開":
                    button1.Enabled = false;
                    btn消去.Enabled = true;
                    button1.Text = "追跡停止";
                    break;
                default:
                    Debug.Fail("ボタン");
                    return;
            }
            folderForm.パラメータ反映();
            main_process();
            button1.Enabled = true;
        }

        private System.Threading.Mutex objMutex;
        DateTime starttime;
        Boolean conflict = false;
        string 氏名;
        public List<string> servers = new List<string>();
        public int serverPort;
        public int watchPort;
        public int trackPort;
        List<string> networks = new List<string>();
        public string untouchableFolder;
        private string version;

        public string Version {
            get { return version; }
            set { version = value; }
        }

        //ＦＯＲＭ表示時
        private void Form1_Load(object sender, EventArgs e) {
            objMutex = new System.Threading.Mutex(false, "fdTRCE");
            if(objMutex.WaitOne(0, false) == false) {
                MessageBox.Show("すでに追跡ツールが起動しています。一つしか起動出来ません。");
                conflict = true;
                this.Close();
            }
            folderForm = new Folder(this);
            folderForm.パラメータ入手();
            folderForm.構成入手(ref servers, ref serverPort, ref watchPort, ref trackPort, ref networks, ref untouchableFolder);
            //復元
            if(System.IO.File.Exists(System.AppDomain.CurrentDomain.BaseDirectory + "TrackInfoSaved.xml")) {
                DataSet infodataset = new DataSet();
                infodataset.ReadXml(System.AppDomain.CurrentDomain.BaseDirectory + "TrackInfoSaved.xml");
                //レイアウト復元
                DataRow r = infodataset.Tables["layoutinfo"].Rows[0];
                int x = (Convert.ToInt32(r[0]) < 0) ? 0 : Convert.ToInt32(r[0]);
                int y = (Convert.ToInt32(r[1]) < 0) ? 0 : Convert.ToInt32(r[1]);
                DesktopLocation = new System.Drawing.Point(x, y);
                int width = (Convert.ToInt32(r[2]) == 0) ? 900 : Convert.ToInt32(r[2]);
                int height = (Convert.ToInt32(r[3]) == 0) ? 400 : Convert.ToInt32(r[3]);
                ClientSize = new System.Drawing.Size(width, height);
                //欄位置復元
                DataRow row = infodataset.Tables["dgcolumninfo"].Rows[0];
                int i = 0;
                foreach(DataGridViewColumn dgcol in dataGridView2.Columns) {
                    dgcol.DisplayIndex = Int32.Parse(row[i++].ToString());
                }
            }
            //追跡ファイル復元
            if(System.IO.File.Exists(System.AppDomain.CurrentDomain.BaseDirectory + "追跡文書名引継ぎファイル.xml")) {
                dataSet2.Clear();
                dataSet2.ReadXml(System.AppDomain.CurrentDomain.BaseDirectory + "追跡文書名引継ぎファイル.xml");
                this.dataGridView2.DataSource = dataSet2;   //テーブル名はＸＭＬより
            }
            this.追跡ファイル復元済み = true;
        }
        private bool 追跡ファイル復元済み = false;

        //表示後
        private void Form1_Shown(object sender, EventArgs e) {
            if(ADuser.getUserInfo(Environment.UserName.ToString(), "name", out 氏名) != 0) {
                氏名 = Environment.UserName;
            };
            氏名 = 氏名.Replace(" ", "");
            AssemblyName AssemblyName = Assembly.GetExecutingAssembly().GetName();
            lblVersion.Text += version = AssemblyName.Version.ToString();
            lbl_comboErr.Text = lbl_パスerr.Text = lbl_コメントerr.Text = "";
            toolStripStatusLabel1.Text = "通知数=0";
            starttime = DateTime.Now;
            main_process();//開始
            dataGridView2.CurrentCell = null;//セルの選択を一時中止するモード
        }

        //開始処理（Form-Loadよりcall）
        recieveprocess rcv;
        System.Threading.Thread thread2;
        public UdpClient udp;
        private void main_process() {
            #region 初期状態設定
            if(udp == null) udp = new UdpClient(trackPort);
            sendToServer("putLog", "start");
            comboBox1.Items.Clear();
            comboBox1.Items.AddRange(types.ToArray());
            bool reached = false;
            int reachedcnt = 0;
            foreach(DataRow r in dataSet2.Tables[0].Rows) {
                if(r["reach"].ToString() == "着") {
                    reached = true;
                    reachedcnt++;
                }
            }
            if(reached) {
                icon = c_color;
                notifyIcon2.Visible = true;
            }
            else {
                icon = c_white;
                notifyIcon1.Visible = true;
            }
            notifyIcon2.Text = String.Format("到着数 {0}件\n", reachedcnt);
            toolStripStatusLabe2.Text = String.Format("到着数={0}", reachedcnt); ;
            #endregion

            rcv = new recieveprocess(this);  //受信スレッド開始
            thread2 = new System.Threading.Thread(new System.Threading.ThreadStart(rcv.recieve));
            thread2.Start();

            #region イベント登録
            DataTable t = dataSet2.Tables[0];
            for(int i = 0; i < t.Rows.Count; i++) {
                watcher.Add(new FileSystemWatcher());
                try {
                    watcher[i].Path = folders[types.IndexOf(t.Rows[i]["dockind"].ToString())];
                    watcher[i].Filter = t.Rows[i]["docfolder"].ToString();
                    watcher[i].IncludeSubdirectories = true;
                    watcher[i].NotifyFilter = NotifyFilters.FileName | NotifyFilters.DirectoryName;
                    watcher[i].Created += new FileSystemEventHandler(Createdevent);
                    watcher[i].Renamed += new RenamedEventHandler(Renamedevent);
                    watcher[i].EnableRaisingEvents = true;
                }
                catch(System.ArgumentException ex) {
                    this.colorFont("エラー：" + ex.Message + "(ここは追跡対象から外れます)");
                }
                if(t.Rows[i]["guid"] != null) {
                    //GUID有るので最新文書名照会
                    sendToServer("getdocumentname", t.Rows[i]["guid"].ToString());
                }
            }
            this.normalFont(String.Format("　　追跡開始 {0}", starttime.ToString("MM/dd HH:mm:ss")));
            CreatedEventMethod = new DelegateFileSystemEvent(Createdevent);
            RenamedEventMethod = new DelegateRenamedEvent(Renamedevent);
            #endregion
            #region 後処理
            button1.Text = "追跡停止";
            lbl稼働状況.Text = "文書追跡中...";
            lbl稼働状況.ForeColor = System.Drawing.Color.Blue;
            btn検索し初期設定.Focus();
            dataGridView2.Enabled = true;
            #endregion
            return;
        }

        //ファイル作成イベント処理
        int countOFdisplay = 0;
        private Object thisLock = new Object();

        DelegateFileSystemEvent CreatedEventMethod;
        public void Createdevent(object source, FileSystemEventArgs e) {
            if(this.InvokeRequired) {
                object[] args = { source, e };
                this.Invoke(CreatedEventMethod, args);
                return;
            }
            string ename = e.Name.ToUpper();
            lock(thisLock) {
                int ii;
                string doctype = "*不明*";
                for(ii = 0; ii < folders.Count; ii++) {
                    if(e.FullPath.StartsWith(folders[ii])) {
                        doctype = types[ii];
                        break;
                    }
                }
                this.normalFont(String.Format("　　作成通知 {0}  {1}  {2}", DateTime.Now.ToString("MM/dd HH:mm:ss"), doctype, ename));
                toolStripStatusLabel1.Text = String.Format("通知数={0}", ++countOFdisplay);
                string name = ename.Substring(ename.LastIndexOf("\\") + 1, ename.Length - ename.LastIndexOf("\\") - 1);
                string[] keys = { doctype, name };
                DataRow r2 = dataSet2.Tables[0].Rows.Find(keys);
                if(r2 != null) {
                    r2["time"] = DateTime.Now.ToString("MM/dd HH:mm:ss");
                    r2["place"] = e.FullPath.Replace(folders[ii], "");
                    r2["place"] = r2["place"].ToString().Remove(r2["place"].ToString().LastIndexOf("\\"));
                    reachSet(r2);
                    //if(reaches[ii] + "\\" + r2["docfolder"] == e.FullPath) {
                    //    r2["reach"] = "着";
                    //}
                }
                bool reached = false;
                int reachedcnt = 0;
                foreach(DataRow r in dataSet2.Tables[0].Rows) {
                    if(r[5].ToString() == "着") {
                        reached = true;
                        reachedcnt++;
                    }
                }
                if(reached && icon == c_white) {
                    icon = c_color;
                    notifyIcon1.Visible = false;
                    notifyIcon2.Visible = true;
                }
                DataTable t = dataSet2.Tables[0];
                notifyIcon2.BalloonTipTitle = doctype + " 到着";
                notifyIcon2.BalloonTipText = String.Format("到着計 {0}件", reachedcnt);
                notifyIcon2.ShowBalloonTip(10000); //Min 10,000 in win
                notifyIcon2.Text = String.Format("到着計 {0}件\n", reachedcnt);
                toolStripStatusLabe2.Text = String.Format("到着数={0}", reachedcnt); ;
            }
        }

        //文書名変更イベント処理
        DelegateRenamedEvent RenamedEventMethod;
        private void Renamedevent(object source, RenamedEventArgs e) {
            if(this.InvokeRequired) {
                object[] args = { source, e };
                this.Invoke(RenamedEventMethod, args);
                return;
            }
            string ename = e.Name.ToUpper();
            string eoldname = e.OldName.ToUpper();
            lock(thisLock) {
                int ii;
                string doctype = "*不明*";
                for(ii = 0; ii < folders.Count; ii++) {
                    if(e.FullPath.StartsWith(folders[ii])) {
                        doctype = types[ii];
                        break;
                    }
                }
                this.normalFont(String.Format("名前変更通知 {0}  {1}  {2}  【旧名： {3}】", DateTime.Now.ToString("MM/dd hh:mm:ss"), doctype, ename, eoldname));
                toolStripStatusLabel1.Text = String.Format("通知数={0}", ++countOFdisplay);
                //
                string name = ename.Substring(ename.LastIndexOf("\\") + 1, ename.Length - ename.LastIndexOf("\\") - 1);
                string oldname = eoldname.Substring(eoldname.LastIndexOf("\\") + 1, eoldname.Length - eoldname.LastIndexOf("\\") - 1);
                string[] keys = { doctype, oldname };
                DataRow r2 = dataSet2.Tables[0].Rows.Find(keys);
                if(r2 != null) {
                    r2["docfolder"] = name; ;
                    r2["rename"] = oldname;
                }
                ((FileSystemWatcher)source).EnableRaisingEvents = false; //新しい名前でイベント登録
                ((FileSystemWatcher)source).Filter = name;
                ((FileSystemWatcher)source).EnableRaisingEvents = true;
            }
        }


        #region 印書処理
        private void 印刷PToolStripButton_Click(object sender, EventArgs e) {
            FormPrint(this);
        }

        //フォーム印書
        internal void FormPrint(Form frm) {
            //フォームのイメージを取得する
            Graphics mygraphics = frm.CreateGraphics();
            memoryImage = new Bitmap(frm.ClientRectangle.Width, frm.ClientRectangle.Height, mygraphics);
            Graphics memoryGraphics = Graphics.FromImage(memoryImage);
            IntPtr dc1 = mygraphics.GetHdc();
            IntPtr dc2 = memoryGraphics.GetHdc();
            BitBlt(dc2, 0, 0, frm.ClientRectangle.Width, frm.ClientRectangle.Height, dc1, 0, 0, 13369376);
            mygraphics.ReleaseHdc(dc1);
            memoryGraphics.ReleaseHdc(dc2);
            //ダイアログ
            PrintDialog dilg = new PrintDialog();
            dilg.PrinterSettings = new System.Drawing.Printing.PrinterSettings();
            DialogResult ans = dilg.ShowDialog();
            if(ans == DialogResult.OK) {
                //フォームのイメージを印刷する
                System.Drawing.Printing.PrintDocument PrintDocument1 = new System.Drawing.Printing.PrintDocument();
                System.Drawing.Printing.PrinterSettings ps = new System.Drawing.Printing.PrinterSettings();
                ps.DefaultPageSettings.Landscape = true;
                PrintDocument1.PrinterSettings = ps;
                PrintDocument1.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(PrintDocument1_PrintPage);
                PrintDocument1.Print();
            }
        }

        [System.Runtime.InteropServices.DllImport("gdi32.dll")]
        private static extern bool BitBlt(IntPtr hdcDest,
             int nXDest, int nYDest, int nWidth, int nHeight,
             IntPtr hdcSrc, int nXSrc, int nYSrc, int dwRop);
        private Bitmap memoryImage;
        //印書イベントハンドラ
        private void PrintDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e) {
            e.Graphics.DrawImage(memoryImage, 0, 0);
        }
        #endregion

        //ヘルプボタン押下
        private void ヘルプLToolStripButton_Click(object sender, EventArgs e) {
            About AboutForm = new About(this);
            AboutForm.ShowDialog();
            AboutForm.Dispose();
        }

        //フォーム終了時
        private void Form1_FormClosing(object sender, FormClosingEventArgs e) {
            if(!conflict) {
                //ファイルウォッチャー解除
                foreach(FileSystemWatcher w in watcher) {
                    w.EnableRaisingEvents = false;
                }
                this.normalFont(String.Format("　　追跡終了 {0}", DateTime.Now.ToString("MM/dd HH:mm:ss")));
                //ログ電文送信
                TimeSpan elaps = DateTime.Now.Subtract(starttime);
                string xelaps = string.Format("{0}:{1}:{2}", elaps.Hours, elaps.Minutes, elaps.Seconds);
                sendToServer("putLog", "fin", textBoxIn.Lines.Length.ToString() + "lines", "elaps" + xelaps);
                //udp.Close();//送信用クローズ
                closeCommunication();
                //ログファイル出力
                System.IO.File.AppendAllText(AppDomain.CurrentDomain.BaseDirectory + "文書追跡ログ.txt", textBoxIn.Text, Encoding.GetEncoding("shift_jis"));
                //追跡文書パラメータ保存
                saveDocNameForTrack();
                //フォーム位置保存準備
                DataSet infodataset = new DataSet();
                DataTable t = infodataset.Tables.Add("layoutinfo");
                t.Columns.Add("X");
                t.Columns.Add("Y");
                t.Columns.Add("Width");
                t.Columns.Add("Height");
                t.Rows.Add(this.DesktopLocation.X, DesktopLocation.Y, ClientSize.Width, ClientSize.Height);
                //欄位置保存準備
                t = infodataset.Tables.Add("dgcolumninfo");
                DataRow row = t.NewRow();
                int i = 0;
                foreach(DataGridViewColumn dgcol in dataGridView2.Columns) {
                    t.Columns.Add(dgcol.HeaderText);
                    row[i++] = dgcol.DisplayIndex;
                }
                t.Rows.Add(row);
                //保存ファイルへ出力
                System.IO.StreamWriter istrm = new System.IO.StreamWriter(System.AppDomain.CurrentDomain.BaseDirectory + "TrackInfoSaved.xml", false, System.Text.Encoding.UTF8);
                infodataset.WriteXml(istrm);
                istrm.Close();

                objMutex.ReleaseMutex();//ミューテックスを解放する
            }
        }

        //追跡文書パラメータ保存
        public void saveDocNameForTrack() {
            if(this.追跡ファイル復元済み) {
                System.IO.StreamWriter strm = new System.IO.StreamWriter(System.AppDomain.CurrentDomain.BaseDirectory + "追跡文書名引継ぎファイル.xml", false, System.Text.Encoding.UTF8);
                dataSet2.WriteXml(strm);
                strm.Close();
            }
        }

        //受信終了処理
        private void closeCommunication() {
            if(thread2.IsAlive) {
                rcv.recieveclose(); //受信停止
                thread2.Join();
            }
        }

        //フォーム終了後
        private void Form1_FormClosed(object sender, FormClosedEventArgs e) {
            objMutex.Close(); //ミューテックスを解放する
        }

        //終了ボタン押下
        private void button2_Click(object sender, EventArgs e) {
            this.Close();
        }

        //アイコンメニューの終了クリック
        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e) {
            this.Close();
        }

        //アイコンメニューの表示をクリック
        private void 表示するToolStripMenuItem_Click(object sender, EventArgs e) {
            this.Visible = true;
        }

        //パラメータ設定ボタン
        private void btn設定_Click(object sender, EventArgs e) {
            folderForm.ShowDialog();

        }

        //画面を消すボタン
        private void btn消去_Click(object sender, EventArgs e) {
            if(notifyIcon1.Visible == true || notifyIcon2.Visible == true) {
                this.Visible = false;
            }
        }

        //タスクトレイアイコンクリック
        private void notifyIcon1_Click(object sender, EventArgs e) {
            if(this.Visible == false) {
                this.Visible = true; // フォームの表示
                if(this.WindowState == FormWindowState.Minimized) {   //最小になってれば
                    this.WindowState = FormWindowState.Normal; // 最小化をやめる
                }
                this.Activate(); // フォームを前面に出す
            }
            else {
                this.Visible = false; // 消去
            }

        }

        //登録（追跡文書）
        private void btn追加_Click(object sender, EventArgs e) {
            lbl_comboErr.Text = lbl_パスerr.Text = lbl_コメントerr.Text = "";
            if(comboBox1.Text == "" || comboBox1.Text == "選択する") { lbl_comboErr.Text = "選択して下さい"; return; };
            if(txtパス.Text == "") { lbl_パスerr.Text = "文書名を記入して下さい"; return; };
            if(txtパス.Text.Contains("\\")) { lbl_パスerr.Text = "\\記号は使用できません"; return; };
            if(txtパス.Text.Contains("|")) { lbl_パスerr.Text = "|記号は使用できません"; return; };
            if(txtコメント.Text.Contains("|")) { lbl_コメントerr.Text = "|記号は使用できません"; return; }
            bool exist文書 = false; ;
            string existパス = "";
            string topPath = folders[types.IndexOf(comboBox1.Text)];
            if(ck存在.Checked) {
                exist文書 = kensaku.DocumentSearch.search(topPath, txtパス.Text, ref  existパス);
                if(!exist文書) {
                    lbl_パスerr.Text = string.Format("該当文書なし"); return;
                }
            }
            DataTable t = dataSet2.Tables[0];
            foreach(DataRow r in t.Rows) {
                if(r[dockind.Index].ToString() == comboBox1.Text && r["docfolder"].ToString() == txtパス.Text.ToUpper()) {
                    lbl_パスerr.Text = "既に登録されています";
                    return;
                }
            }
            DataRow nr = t.NewRow();
            nr["dockind"] = comboBox1.Text;
            nr["docfolder"] = txtパス.Text.ToUpper();
            if(ck存在.Checked) {
                string str = existパス.Replace(topPath, "");
                nr["place"] = str.Remove(str.LastIndexOf('\\')).ToUpper(); ;
            }
            else {
                nr["place"] = "-";
            }
            nr["comment"] = txtコメント.Text;
            if(ck至急.Checked) {
                nr["priority"] = "至急";
            }
            else {
                nr["priority"] = "";
            }
            string guid = System.Guid.NewGuid().ToString();
            nr["guid"] = guid;
            t.Rows.Add(nr);
            sendToWatcher("putdocumentinfo", folders[types.IndexOf(comboBox1.Text)], txtパス.Text.ToUpper(), txtコメント.Text, nr["priority"].ToString(), guid);
            sendToServer("putdocumentinfo", folders[types.IndexOf(comboBox1.Text)], txtパス.Text.ToUpper(), txtコメント.Text, nr["priority"].ToString(), guid);

            FileSystemWatcher w = new FileSystemWatcher();
            try {
                w.Path = folders[types.IndexOf(comboBox1.Text)];
                w.Filter = txtパス.Text;
                w.IncludeSubdirectories = true;
                w.NotifyFilter = NotifyFilters.FileName | NotifyFilters.DirectoryName;
                w.Created += new FileSystemEventHandler(Createdevent);
                w.Renamed += new RenamedEventHandler(Renamedevent);
                w.EnableRaisingEvents = true;
            }
            catch(System.ArgumentException ex) {
                this.colorFont("エラー：" + ex.Message + "(この文書の追跡のための登録がエラーになりました。この文書種類はフォルダが存在していない可能性があります。)");
            }
            watcher.Add(w);
            comboBox1.ResetText();
            txtパス.Clear();
            txtコメント.Clear();
            ck至急.Checked = false;
            saveDocNameForTrack();
        }

        //フォルダ参照ボタン
        private void btn参照_Click(object sender, EventArgs e) {
            if(comboBox1.Text != "選択する") {
                folderBrowserDialog1.SelectedPath = folders[types.IndexOf(comboBox1.Text)];
            }
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if(result == System.Windows.Forms.DialogResult.OK) {
                txtパス.Text = folderBrowserDialog1.SelectedPath;
                txtパス.Text = txtパス.Text.Substring(txtパス.Text.LastIndexOf("\\") + 1, txtパス.Text.Length - txtパス.Text.LastIndexOf("\\") - 1);
                btn追加.Focus();
            }
        }

        //行削除
        private void dataGridView2_UserDeletingRow(object sender, DataGridViewRowCancelEventArgs e) {
            if(MessageBox.Show(string.Format("この文書の追跡を止めますか？{0}{0}種類＝{1}{0}文書＝{2}", "\r\n", dataSet2.Tables[0].Rows[e.Row.Index]["dockind"].ToString(), dataSet2.Tables[0].Rows[e.Row.Index]["docfolder"].ToString()), "行の消去", MessageBoxButtons.YesNo) == DialogResult.Yes) {
                for(int i = 0; i < watcher.Count; i++) {
                    try {
                        if(watcher[i].Path == folders[types.IndexOf(dataSet2.Tables[0].Rows[e.Row.Index]["dockind"].ToString())] && watcher[i].Filter == dataSet2.Tables[0].Rows[e.Row.Index]["docfolder"].ToString()) {
                            watcher[i].EnableRaisingEvents = false;
                            watcher.Remove(watcher[i]);
                        }
                    }
                    catch { }
                }
                try {
                    sendToServer("deldocumentinfo", folders[types.IndexOf(dataSet2.Tables[0].Rows[e.Row.Index]["dockind"].ToString())] + "|" + dataSet2.Tables[0].Rows[e.Row.Index]["docfolder"].ToString());
                }
                catch { }

                int reachedcnt = 0;
                foreach(DataRow r in dataSet2.Tables[0].Rows) {
                    if(r["reach"].ToString() == "着") {
                        reachedcnt++;
                    }
                }
                if(reachedcnt == 1) {
                    icon = c_white;
                    notifyIcon1.Visible = true;
                    notifyIcon2.Visible = false;
                }
            }
            else {
                e.Cancel = true;
            }

        }

        //まとめて検索ボタン押下
        System.Threading.Thread searchthread;
        private void btn検索し初期設定_Click(object sender, EventArgs e) {
            searchthread = new System.Threading.Thread(new System.Threading.ThreadStart(searchprocess));
            searchthread.Start();
        }

        //まとめて検索時のスレッド
        public void searchprocess() {
            //ボタン灰色化
            controlAccess("disable");
            //クリア
            lock(thisLock) {
                foreach(DataRow r in dataSet2.Tables[0].Rows) {
                    r["place"] = "";
                }
            }
            DataView dv = dataSet2.Tables[0].DefaultView;
            //ソートビュー
            dv.Sort = "dockind, docfolder ASC";
            List<string> searchfolder = new List<string>();
            List<bool> found = new List<bool>();
            List<string> foundpath = new List<string>();
            int startrow = 0;
            for(int i = 0; i < dv.Count; i++) {
                searchfolder.Add((string)dv[i]["docfolder"]);
                //found.Add(false);
                //foundpath.Add("");
                //
                if(i == dv.Count - 1 || (string)dv[i + 1]["dockind"] != (string)dv[i]["dockind"]) {
                    //種類が変わるか最後の行になったのでそこまでを一括検索
                    string toppath = folders[types.IndexOf((string)dv[i]["dockind"])];
                    kensaku.DocumentSearch.multifoldersearch(toppath, searchfolder, ref found, ref foundpath);
                    lock(thisLock) {
                        for(int j = 0; j < foundpath.Count; j++) {
                            if(found[j] == true) {
                                //あるケース
                                string str = foundpath[j].Replace(toppath, "");
                                dv[startrow + j]["place"] = str.Remove(str.LastIndexOf("\\")).ToUpper();
                                //「着」設定
                                reachSet(dv[startrow + j].Row);
                            }
                            else {
                                dv[startrow + j]["place"] = "x";
                            }
                        }
                    }
                    startrow += foundpath.Count;
                    searchfolder.Clear();
                    found.Clear();
                    foundpath.Clear();
                }
            }
            //灰色ボタン戻し
            controlAccess("enable");
        }

        //「着」文字の設定
        private void reachSet(DataRow dr) {
            if(dr["reach"].ToString() != "着") {
                string topFolder = folders[types.IndexOf(dr["dockind"].ToString())];
                string currentSubfolder = dr["place"].ToString();
                string fullpath = Path.Combine(topFolder, currentSubfolder.Substring(1));
                string reachSubfolder = reaches[types.IndexOf(dr["dockind"].ToString())];
                if(fullpath.StartsWith(reachSubfolder)) {
                    dr["reach"] = "着";
                };
            }
        }

        //監視ツールへ送信
        void sendToWatcher(params string[] text) {
            //if(udp == null) udp = new UdpClient(trackPort);
            udp.EnableBroadcast = true;
            udp.MulticastLoopback = true;
            try {
                byte[] bytes = Encoding.UTF8.GetBytes(DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + 氏名 + "|TRACK|" + version + "|" + string.Join("|", text));
                foreach(string network in networks) {
                    udp.Send(bytes, bytes.Length, network, watchPort);
                    //Debug.WriteLine("send msg tonetwork=" + network + ", toport=" + watchPort);
                }
            }
            catch(Exception) {
                this.colorFont("udp send to watcher exception");
            }

        }

        //追跡ツールへ送信
        void sendToTracker(params string[] text) {
            //if(udp == null) udp = new UdpClient(trackPort);
            udp.EnableBroadcast = true;
            udp.MulticastLoopback = true;
            try {
                byte[] bytes = Encoding.UTF8.GetBytes(DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + 氏名 + "|TRACK|" + version + "|" + string.Join("|", text));
                foreach(string network in networks) {
                    udp.Send(bytes, bytes.Length, network, trackPort);
                    //Debug.WriteLine("send msg tonetwork=" + network + ", toport=" + trackPort);
                }
            }
            catch(Exception) {
                this.colorFont("udp send to Tracker exception");
            }

        }

        //サーバーへ送信
        void sendToServer(params string[] text) {
            if(udp == null) udp = new UdpClient(trackPort);//停止中の終了
            //udp.EnableBroadcast = true;
            //udp.MulticastLoopback = true;
            try {
                byte[] bytes = Encoding.UTF8.GetBytes(DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + 氏名 + "|TRACK|" + version + "|" + string.Join("|", text));
                foreach(string server in servers) {
                    udp.Send(bytes, bytes.Length, server, serverPort);
                    Debug.WriteLine("send msg tohost=" + server + ", toport=" + serverPort);
                }
            }
            catch(Exception) {
                this.colorFont("udp send to server exception");
            }
        }

        //リンククリック
        private void dataGridView2_CellContentClick(object sender, DataGridViewCellEventArgs e) {
            if(e.ColumnIndex == docfolder.Index && e.RowIndex != -1) {
                string f3 = dataGridView2.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
                string xf1 = dataGridView2.Rows[e.RowIndex].Cells[dockind.Index].Value.ToString();
                string f1 = folders[types.IndexOf(xf1)];
                string f2 = dataGridView2.Rows[e.RowIndex].Cells[place.Index].Value.ToString();
                if(f2 == "" || f2 == "x") {
                    MessageBox.Show("この文書の「現在の場所」が埋まっていない為、開けません");
                    return;
                }
                string path = f1 + f2 + "\\" + f3;
                if(untouchableFolder != string.Empty && path.Contains(untouchableFolder)) {
                    path = (new untoutchable()).untouchableFolderCopy(path);
                }
                if(path != "") {
                    Process ex = new Process();
                    ex.StartInfo.FileName = path;  //Explorer
                    try {
                        ex.Start(); //プロセス起動
                    }
                    catch(System.ComponentModel.Win32Exception) {
                        MessageBox.Show("開けません");
                    }
                    catch(Exception exa) {
                        MessageBox.Show(exa.Message);
                    }
                }
            }

        }


        private void label8_Click(object sender, EventArgs e) {

        }

        //セルクリックすべて
        private void dataGridView2_CellClick(object sender, DataGridViewCellEventArgs e) {
            if(e.ColumnIndex == priority.Index && e.RowIndex != -1) {
                //緊急度変更
                DataGridViewRow gr = dataGridView2.Rows[e.RowIndex];
                if(gr.Cells[e.ColumnIndex].Value.ToString() == "") {
                    if(MessageBox.Show("至急扱いに変更しますか？" + Environment.NewLine + "変更はすぐに他の人の画面に反映されます。", "緊急度変更", MessageBoxButtons.YesNo) == DialogResult.Yes) {
                        gr.Cells[e.ColumnIndex].Value = "至急";
                        DataRow dr = ((DataRowView)gr.DataBoundItem).Row;
                        sendToWatcher("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                        sendToServer("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                        sendToTracker("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                    }
                }
                else {
                    if(MessageBox.Show("通常扱いに戻しますか？" + Environment.NewLine + "変更はすぐに他の人の画面に反映されます。", "緊急度変更", MessageBoxButtons.YesNo) == DialogResult.Yes) {
                        gr.Cells[e.ColumnIndex].Value = "";
                        DataRow dr = ((DataRowView)gr.DataBoundItem).Row;
                        sendToWatcher("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                        sendToServer("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                        sendToTracker("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());

                    }
                }
            }
            else if(e.ColumnIndex == place.Index && e.RowIndex != -1) {
                //現在の場所を検索
                {
                    //場所セルクリア
                    dataGridView2.Rows[e.RowIndex].Cells[place.Index].Value = "";
                    //再表示
                    dataGridView2.Refresh();
                    //検索
                    string topfolder = folders[types.IndexOf(dataGridView2.Rows[e.RowIndex].Cells[dockind.Index].Value.ToString())];
                    List<string> docname = new List<string>();
                    docname.Add(dataGridView2.Rows[e.RowIndex].Cells[docfolder.Index].Value.ToString());
                    List<bool> found = new List<bool>();
                    List<string> foundpath = new List<string>();
                    kensaku.DocumentSearch.multifoldersearch(topfolder, docname, ref found, ref foundpath);
                    if(found[0] == true) {
                        //セルにセット
                        string str = foundpath[0].Replace(topfolder, "");
                        dataGridView2.Rows[e.RowIndex].Cells[place.Index].Value = str.Remove(str.LastIndexOf("\\")).ToUpper();
                        //「着」セット
                        DataRow dr = dataSet2.Tables[0].Rows[e.RowIndex];
                        reachSet(dr);
                    }
                    else {
                        dataGridView2.Rows[e.RowIndex].Cells[place.Index].Value = "x";
                    }

                }
            }

        }

        //コメント修正
        private void dataGridView2_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e) {
            if(e.ColumnIndex == dataGridView2.Columns.IndexOf(comment)) {
                beforcell = dataGridView2.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
            }
        }
        string beforcell;
        private void dataGridView2_CellEndEdit(object sender, DataGridViewCellEventArgs e) {
            if(e.ColumnIndex == dataGridView2.Columns.IndexOf(comment))
            //コメント欄の修正
            {
                DataGridViewRow gr = dataGridView2.Rows[e.RowIndex];
                if(beforcell != dataGridView2.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString())
                //修正あり
                {
                    DataRow dr = ((DataRowView)gr.DataBoundItem).Row;
                    dr["comment"] = dr["comment"].ToString().Replace('|', '｜');
                    sendToWatcher("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                    sendToTracker("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                    sendToServer("replacecomment", folders[types.IndexOf(dr["dockind"].ToString())], dr["docfolder"].ToString(), dr["comment"].ToString(), dr["priority"].ToString(), dr["guid"].ToString());
                };
            }
        }

        //ＣＳＶボタンクリック
        private void button3_Click(object sender, EventArgs e) {
            string prpath = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            System.IO.StreamWriter csvpr = new StreamWriter(prpath + @"\追跡文書リスト.CSV", false, Encoding.GetEncoding("Shift_JIS"));
            string[] str = new string[dataGridView2.Columns.Count]; //カラム数以上を指定する
            int i = 0;
            //見出し行
            foreach(DataGridViewColumn c in dataGridView2.Columns) {
                str[i++] = c.HeaderText;
            }
            csvpr.WriteLine(string.Join(",", str));
            //データ行
            foreach(DataGridViewRow r in dataGridView2.Rows) {
                i = 0;
                foreach(DataGridViewColumn c in dataGridView2.Columns) {
                    str[i] = r.Cells[i++].Value.ToString();
                }
                csvpr.WriteLine(string.Join(",", str));
            }
            csvpr.Close();
            MessageBox.Show("デスクトップに「追跡文書リスト.CSV」の名で出力しました。");
        }

        //まとめて検索時のEnable or Disable
        DelegateControlAccess method;
        private void controlAccess(string require) {
            if(this.InvokeRequired) {
                object[] args = { require };
                method = new DelegateControlAccess(controlAccess);
                this.Invoke(method, args);
                return;
            }
            if(require == "disable") {
                btn検索し初期設定.Enabled = false;
                this.normalFont(String.Format("　　検索開始 {0}", DateTime.Now.ToString("MM/dd HH:mm:ss")));
            }
            if(require == "enable") {
                btn検索し初期設定.Enabled = true;
                this.normalFont(String.Format("　　検索終了 {0}", DateTime.Now.ToString("MM/dd HH:mm:ss")));
                //画面リフレッシュ
                dataGridView2.Refresh();
            }
        }

        //検索ボタン
        private void btn検索_Click(object sender, EventArgs e) {

            if(comboBox1.Text == "") { lbl_comboErr.Text = "選択して下さい"; return; }
            if(txtパス.Text == "") { lbl_パスerr.Text = "検索の場合は文字列を入力して下さい"; return; }
            if(backgroundWorker1.IsBusy) {
                MessageBox.Show("検索画面を閉じて下さい");
                return;
            }
            if(MessageBox.Show("①の文書種類の範囲で②の部分文字列を含む文書フォルダをリストアップします。" + Environment.NewLine + "但し探索の深さは名前が「nn_xxxxxx」「!xxxxxx」の形式のディレクトリまでです。" + Environment.NewLine + "また「一段下も検索」をチェックした場合は" + Environment.NewLine + "時間はかかりますが一段下のExcelファイル等も検索します", "確認", MessageBoxButtons.OKCancel, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1) == DialogResult.OK) {
                try {
                    toppath = folders[types.IndexOf(comboBox1.Text)];
                    backgroundWorker1.RunWorkerAsync();
                }
                catch {
                    MessageBox.Show("文書種類を正しく選択して下さい");
                    return;
                }
            }
        }
        //検索時の起動スレッド
        private string toppath;
        public string docname = "";
        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e) {
            docname = "";
            Application.Run(new 検索Form(this, toppath, txtパス.Text, ckレベル.Checked));
        }

        //検索FORM終了時イベント
        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e) {
            if(docname != "") txtパス.Text = docname;//文書名取り込み
        }

        //文書種類BOX選択時
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e) {
            lbl_comboErr.Text = "";
            txtパス.Focus();
            this.AcceptButton = btn検索;
        }

        //文書入力枠クリック時
        private void txtパス_Click(object sender, EventArgs e) {
            lbl_パスerr.Text = "";
            this.AcceptButton = btn検索;
        }

        private void label2_Click(object sender, EventArgs e) {

        }

        private void normalFont(string txt) {
            this.textBoxIn.AppendText(txt);
            textBoxIn.SelectionStart = textBoxIn.TextLength;
            textBoxIn.ScrollToCaret();
            this.textBoxIn.AppendText("\r");
        }

        private void colorFont(string txt) {
            textBoxIn.SelectionColor = Color.Red;
            this.textBoxIn.AppendText(txt);
            textBoxIn.SelectionColor = Color.Empty;
            textBoxIn.SelectionStart = textBoxIn.TextLength;
            textBoxIn.ScrollToCaret();
            this.textBoxIn.AppendText("\r");
        }

        private void tableLayoutPanel2_Paint(object sender, PaintEventArgs e) {

        }

        private void ｂｔｎクリア_Click(object sender, EventArgs e) {
            txtパス.Clear();
            lbl_パスerr.Text = "";
        }

        private void txtコメント_Click(object sender, EventArgs e) {
            //lbl_コメントerr.Text = "";
            //this.AcceptButton = btn追加;
        }

        private void ck至急_Click(object sender, EventArgs e) {
            this.AcceptButton = btn追加;
        }

        private void txtコメント_Enter(object sender, EventArgs e) {
            lbl_コメントerr.Text = "";
            this.AcceptButton = btn追加;
        }

    }
    delegate void DelegateFileSystemEvent(object source, FileSystemEventArgs e);  //デリゲート定義
    delegate void DelegateRenamedEvent(object source, RenamedEventArgs e);  //デリゲート定義
    delegate void DelegateControlAccess(string require);  //デリゲート定義

}